### A Pluto.jl notebook ###
# v0.19.42

using Markdown
using InteractiveUtils

# ╔═╡ b72215bb-8e3a-46e2-8817-271befe1178c
begin
	using PlotlyBase , HypertextLiteral , PlutoUI, CSV , DataFrames , Dates , PeriodicalDates
	using SparseArrays , StatsBase , LinearAlgebra, PlotlyKaleido, PlutoPlotly
	import Statistics:std
	PlotlyKaleido.start(;mathjax = true)
end

# ╔═╡ 0b869e70-3717-11ec-202c-6b94dac7daf3
md"""
# Exame: Macroeconomics (M8674)

## Instituto Universitário de Lisboa (ISCTE--IUL)

**27 May 2024**
"""

# ╔═╡ 7e9874b4-a6bd-4b2e-b2db-9421b2f85253
md"""
!!! danger "Compulsory"

	👉 Fill in your name and student number in the cells below.

"""

# ╔═╡ b5c47c65-951b-496b-9856-7fd151e7a0f1
name = "My name"

# ╔═╡ 23e904ee-8f26-4e5e-8a82-b83c4b0610b6
number = 000000

# ╔═╡ 694d78c7-4762-4d40-8f9a-6c3d16916d4e
begin
	function Base.show(io::IO, mimetype::MIME"text/html", plt::PlotlyBase.Plot)
       # Remove responsive flag on the plot as we handle responsibity via ResizeObeserver and leaving it on makes the div flickr during updates
	hasproperty(plt,:config) && plt.config.responsive && (plt.config.responsive = false)   
	show(io,mimetype, @htl("""
			<div>
			<script id=asdf>
			const {plotly} = await import("https://cdn.plot.ly/plotly-2.2.0.min.js")
			const PLOT = this ?? document.createElement("div");
		

		
			Plotly.react(PLOT, $(HypertextLiteral.JavaScript(PlotlyBase.json(plt))));


		
			const pluto_output = currentScript.parentElement.closest('pluto-output')

			const resizeObserver = new ResizeObserver(entries => {
				Plotly.Plots.resize(PLOT)
			})

			resizeObserver.observe(pluto_output)

			invalidation.then(() => {
				resizeObserver.disconnect()
			})
		
			return PLOT
			</script>
			</div>
	"""))
	end
end

# ╔═╡ a2a3fa86-6e22-433e-9185-147e39059dd2
md"""
## Packages
"""

# ╔═╡ 8b34e2c6-34ba-48c0-b7ab-96e14a974adc
md"""
______________________________________________________________________________________________________________________
"""

# ╔═╡ 4109af60-6178-4148-8efe-890245077188
md"""
## I - Downloading data 
"""

# ╔═╡ 402b0789-ee0a-46a0-b3b6-e4a207ed0322
md"""
👉 **1)** Read/load the file "USdata.csv" data set that is attached to this notebook.

"""

# ╔═╡ fdf4f563-0a9b-416f-b61f-21cac421c975


# ╔═╡ 12574710-db69-4ae8-9f44-c74b3a4dce7b
md"""
👉 **2)** Create a Date object (a set of dates that will be used in the x-axis when plotting) to cover the period of your data.

"""

# ╔═╡ a98a56b8-660f-48d7-b8be-9738f73356ee
period1 = MonthlyDate(1960,1) : Month(1) : MonthlyDate(2023,1)

# ╔═╡ c825ebf2-ce43-452e-aa32-91f2bb4d6be4
md"""
______________________________________________________________________________________________________________________
"""

# ╔═╡ 98989982-df79-46cc-837c-aab48d4d5189
md"""
## II. Performing operations on a data frame (2 points)
"""

# ╔═╡ d29cc7bd-2f31-41ba-9eed-ed142af21de8
md"""
👉 **1)** Using the function `insertcols!`, insert two new columns in our data set: the natural logarithmic of real GDP and the natural logarithmic of real Investment. Notice that we can do this in a single cell, something like this:

```julia
begin
	insertcols!(newUSdata, :lnGDP => log.(newUSdata.GDP))   	# if the data named as newUSdata and real GDP as GDP
	insertcols!(newUSdata, :lnINV => log.(newUSdata.INV))   	# if ... real Investment as INV
end
```
"""

# ╔═╡ d33a43d3-542b-49ec-87f5-627b1b1d18f6


# ╔═╡ da39aafe-7826-4044-92fe-689b0c4ba46e
md"""
👉 **2)** Using the function `select`, create a new data set, which should be called **_USdata2_**, and include only the following aggregates: the CPI, the Unemployment Rate, the logarithmic value of real GDP, and the logarithmic value of real Investment.

"""

# ╔═╡ 3b99ab82-dfbf-4ce9-8b9c-fb6411563ddd
md"""
!!! hint

	Do not forget to name this new data set as `USdata2`, otherwise the Hodrick-Prescott filter in the following exercise will not work.
"""

# ╔═╡ 0926d86a-cf95-4b1b-ab7f-0533eb51ac70


# ╔═╡ 062ed208-1c98-4339-aeca-16b1522bd437
md"""
______________________________________________________________________________________________________________________
"""

# ╔═╡ 52576c2a-6a38-4873-bf5d-9ccfbd457576
md"""
## III. The Hodrick-Prescott filter (5 points)
"""

# ╔═╡ 1ead53b4-3fab-4dc6-938d-38764c5f5714
md"""

The HP ﬁlter is obtained through the formula:

$$\min _{\tau_{t}} \sum_{t=1}^{T}\left\{\left(y_{t}-\tau_{t}\right)^{2}+\lambda\left[\left(\tau_{t+1}-\tau_{t}\right)-\left(\tau_{t}-\tau_{t-1}\right)\right]^{2}\right\}\tag{1}$$

-  $y_{t}$ is the observed time series
-  $\tau_{t}$ is the smooth trend that we want to obtain
-  $\lambda$ is the parameter that we set to obtain the desired smoothness in the trend

The following cell presents the Julia code of a function we call by `hp_filter`, which minimizes eq.(1), for a given value of the parameter $\lambda$. Do not delete nor change the arguments of this function.  
"""

# ╔═╡ ac7996b1-f68d-4218-b8d3-31af7fe2a7dc
begin
	function hp_filter(USdata2::Array{Float64,1}, lambda::Float64)
    	k = length(USdata2)
    	@assert k >= 4
    	diag2 = lambda*ones(k-2)
    	diag1 = [ -2lambda; -4lambda*ones(k-3); -2lambda ]
    	diag0 = [ 1+lambda; 1+5lambda; (1+6lambda)*ones(k-4); 1+5lambda; 1+lambda ]
    	D = spdiagm(-2 => diag2, -1 => diag1, 0 => diag0, 1 => diag1, 2 => diag2)
    	D\USdata2
	end
end

# ╔═╡ 976f8f6d-3fe4-4c22-9e5c-b6534fa23096
md"""
👉 **1)** Given the frequency of the data that you downloaded from FRED, what is the best value for $\lambda$? Insert that value in the cell below:
"""

# ╔═╡ 42df1d8d-06cc-4722-a2df-a9e4026f0f02
λ = 0.0 				# it has to be a floating number, so do not erase the last .0 part of the number

# ╔═╡ 220511d4-55a3-4a4f-8f88-2177cdab3ee2
md"""
👉 **2)** Compute the Hodrick-Prescott filter for the entire dataset `USdata2`. Notice that the number of observations will be **_252_** and you have 4 variables in your data set. So, to compute the HP filter in your data set, you have to insert in the correponding code cell:

```julia 
hp_trend = zeros(252, 4) 	# 252 is the number of rows in the dataset, if this number changes ....
```
and take also into account that now:

```
n = 1:4
```
	
"""

# ╔═╡ 769bdaf5-0880-40cd-90b4-403546870dc4


# ╔═╡ c25949f7-1d43-40d4-a70e-6582220e7937
md"""
👉 **3)** Compute the business cycle components of the entire dataset `USdata2`. The same observation in the previous question applies here as well.
"""

# ╔═╡ d87eb178-12d2-4201-8aa1-73d1bd730c96
md"""
!!! note

	Give a simple name to the business cycles; `cycles` looks a good one.
"""

# ╔═╡ 1ef0664e-2f1d-4945-9a56-befb916f08ee


# ╔═╡ 008dbf4d-d2c6-42c3-8b78-2cdba0f3a3e2
md"""
👉 **4)** Plot the business cycle components of the entire dataset `USdata2`. 
"""

# ╔═╡ 135ceb08-8ada-43cd-b8fc-1ab46e65a25c


# ╔═╡ 65f3d7a4-7475-4784-8878-07b7cce72d7c
md"""
______________________________________________________________________________________________________________________
"""

# ╔═╡ f363268e-a9b8-4248-8b99-e6429177b718
md"""
## IV. Statistical measures (3 points)
"""

# ╔═╡ 6ddc8586-f918-4f25-aa3f-1eb798eb0220
md"""
This exercise deals with the computation of the main statistical measures for each business-cycle component and will include: (i) the auto-correlation function, (ii) the cross-correlation function, and (iii) the standard deviation.

```julia
autocor(variable)
crosscor(variable1, variable2, lags)
std(variable)
```
"""

# ╔═╡ 25a58610-3d1e-4b8d-a26f-71a4fed12f82
md"""
To make sure we do not make mistakes by calling each column of the matrix `cycles` time and time again, we can pass a name to the business-cycle component of each variable. Copy this code to the cell below and run the cell:

	begin
		cpi_cycles  = cycles[:,1]
		ur_cycles   = cycles[:,2]
		gdp_cycles  = cycles[:,3]
		inv_cycles  = cycles[:,4]
	end
"""

# ╔═╡ 9d441502-30b8-4669-a5db-7ff9f294fcc9


# ╔═╡ ccc1d5f1-1d59-49ea-a3be-1503e1c5369d
md"""
### Auto-correlation
"""

# ╔═╡ 85a4e50a-5367-4ca5-b56f-26467f926225
md"""
👉 **1)** Plot the auto-correlation function for each variable's business-cycle component. By inspecting such plot, what can we conclude about the **persistence** of these four macroeconomic aggregates?	

All we have to do is:

```julia 
Plot(autocor(cycles))
```

and, then, insert the labels manually into the plot by using the `restyle!` function.
	
"""

# ╔═╡ 67b28656-5b16-46c7-a123-85d049bad845


# ╔═╡ 75a7a912-c81c-423e-9d8d-67056ce5e2d2
md"""
!!! tip "Answer IV(1)"

	Here

"""

# ╔═╡ 86cd9e00-72a2-46a1-8572-86fad96484b9
md"""
### Cross-correlation
"""

# ╔═╡ 995cdbb5-54d7-4cff-b4cf-540afcaccc3d
md"""
The cross-correlation function for each variable will come out as:

```julia
crosscor(variable1, variable2, lags)
```
"""

# ╔═╡ 8115fbe8-c004-4d2f-a89c-adbb99a337a4
md"""
👉 **2)** Compute the cross-correlation function of each business cycle component with respect to GDP. Usually, in macroeconomics, all variables are cross-correlated with GDP. Therefore, we have to compute 4 cross-correlation functions in this exercise: 

		CPI vs GDP ,  UR vs GDP ,  GDP vs GDP ,  INV vs GDP.
"""

# ╔═╡ dd6264e6-ef0b-4bf2-aa02-0f3d8a1aed3b
md"""
!!! hint
	We suggest using a code like this:

```
begin
	lags = -20:20;
	cross_cpi_gdp  = crosscor(cpi_cycles , gdp_cycles, lags)
	cross_ur_gdp   = crosscor(ur_cycles  , gdp_cycles, lags)
	cross_gdp_gdp  = crosscor(gdp_cycles , gdp_cycles, lags)
	cross_inv_gdp  = crosscor(inv_cycles , gdp_cycles, lags)
	
	crosscorrelation = [cross_cpi_gdp  cross_ur_gdp  cross_gdp_gdp  cross_inv_gdp]
end
```
"""

# ╔═╡ dc7b0b76-9f15-4e3a-8123-d6b8fcca3c34
md"""
👉 **3)** Plot the cross-correlation function of each business cycle component with respect to GDP. By inspecting such a plot, what variables are (i) pro-cyclical, (ii) counter-cyclical, (iii) acyclical in these five macroeconomic aggregates?

All we have to do is:

```julia 
Plot(autocor(cycles))
```

and, then, insert the labels manually into the plot by using the `restyle!` function.
	
"""

# ╔═╡ 2ad1f73a-ebd1-40ad-b1db-d48ededc9dd5
md"""
!!! tip "Answer IV(2)"

	Here
				
"""

# ╔═╡ 41137424-e8b4-43c0-b282-7baab6668c66
md"""
### Standard deviation
"""

# ╔═╡ 5f164f3c-b18f-44d8-b243-194ccb7c453a
md"""
👉 **3)** Compute the standard deviation of each variable's business-cycle component, and order the variables according to the **volatility** of each one.
"""

# ╔═╡ 74bee8f4-1e6f-4c65-b186-57c1c9c89c6b
md"""
!!! hint

	The computation of the standard deviation is straighforward, just use: 

	```julia
	std(variable)
	```

"""

# ╔═╡ 14b5c3a5-300d-46dd-99e0-20fef8fedb5a


# ╔═╡ dd5d1a4a-60d2-416d-8651-4497ece4889c
md"""
	!!! tip "Answer IV(3)"

	    Here
				
	"""

# ╔═╡ 81c59c4c-2fa3-4a50-aad2-4d56a488afb4
md"""
______________________________________________________________________________________________________________________
"""

# ╔═╡ f2956bed-9534-4c57-bfaa-fbef3c4af810
md"""
## End of test
"""

# ╔═╡ edbd2b1c-1452-41a6-962c-3434bd420020
md"""
## Auxiliary cells (do not change these cells)
"""

# ╔═╡ c7190cc0-08d8-45c8-b5de-e5630e0ff00e
html"""
<style>
	@media screen {
		main {
			margin: 0 auto;
			max-width: 1700px;
    		padding-left: max(200px, 10%);
    		padding-right: max(383px, 10%); 
            # 383px to accomodate TableOfContents(aside=true)
		}
	}
</style>
"""

# ╔═╡ d9672a6f-97af-43d1-9a30-50495204fec8
 TableOfContents()

# ╔═╡ 73ff8fcc-cfd6-45ba-a741-ecfa65a4cf28
begin
      struct TwoColumns{L, R}
    left::L
    right::R
      end
      
      function Base.show(io, mime::MIME"text/html", tc::TwoColumns)
          write(io, """<div style="display: flex;"><div style="flex: 48%;margin-right:2%;">""")
          show(io, mime, tc.left)
          write(io, """</div><div style="flex: 48%;">""")
          show(io, mime, tc.right)
          write(io, """</div></div>""")
      end
end

# ╔═╡ 00000000-0000-0000-0000-000000000001
PLUTO_PROJECT_TOML_CONTENTS = """
[deps]
CSV = "336ed68f-0bac-5ca0-87d4-7b16caf5d00b"
DataFrames = "a93c6f00-e57d-5684-b7b6-d8193f3e46c0"
Dates = "ade2ca70-3891-5945-98fb-dc099432e06a"
HypertextLiteral = "ac1192a8-f4b3-4bfe-ba22-af5b92cd3ab2"
LinearAlgebra = "37e2e46d-f89d-539d-b4ee-838fcccc9c8e"
PeriodicalDates = "276e7ca9-e0d7-440b-97bc-a6ae82f545b1"
PlotlyBase = "a03496cd-edff-5a9b-9e67-9cda94a718b5"
PlotlyKaleido = "f2990250-8cf9-495f-b13a-cce12b45703c"
PlutoPlotly = "8e989ff0-3d88-8e9f-f020-2b208a939ff0"
PlutoUI = "7f904dfe-b85e-4ff6-b463-dae2292396a8"
SparseArrays = "2f01184e-e22b-5df5-ae63-d93ebab69eaf"
Statistics = "10745b16-79ce-11e8-11f9-7d13ad32a3b2"
StatsBase = "2913bbd2-ae8a-5f71-8c99-4fb6c76f3a91"

[compat]
CSV = "~0.10.14"
DataFrames = "~1.6.1"
HypertextLiteral = "~0.9.5"
PeriodicalDates = "~2.0.0"
PlotlyBase = "~0.8.19"
PlotlyKaleido = "~2.2.4"
PlutoPlotly = "~0.4.6"
PlutoUI = "~0.7.59"
StatsBase = "~0.34.3"
"""

# ╔═╡ 00000000-0000-0000-0000-000000000002
PLUTO_MANIFEST_TOML_CONTENTS = """
# This file is machine-generated - editing it directly is not advised

julia_version = "1.10.0"
manifest_format = "2.0"
project_hash = "39d72413ff47ee4dc45237ce52f222a95098784b"

[[deps.AbstractPlutoDingetjes]]
deps = ["Pkg"]
git-tree-sha1 = "6e1d2a35f2f90a4bc7c2ed98079b2ba09c35b83a"
uuid = "6e696c72-6542-2067-7265-42206c756150"
version = "1.3.2"

[[deps.ArgTools]]
uuid = "0dad84c5-d112-42e6-8d28-ef12dabb789f"
version = "1.1.1"

[[deps.Artifacts]]
uuid = "56f22d72-fd6d-98f1-02f0-08ddc0907c33"

[[deps.Base64]]
uuid = "2a0f44e3-6c83-55bd-87e4-b1978d98bd5f"

[[deps.BaseDirs]]
git-tree-sha1 = "cb25e4b105cc927052c2314f8291854ea59bf70a"
uuid = "18cc8868-cbac-4acf-b575-c8ff214dc66f"
version = "1.2.4"

[[deps.CSV]]
deps = ["CodecZlib", "Dates", "FilePathsBase", "InlineStrings", "Mmap", "Parsers", "PooledArrays", "PrecompileTools", "SentinelArrays", "Tables", "Unicode", "WeakRefStrings", "WorkerUtilities"]
git-tree-sha1 = "6c834533dc1fabd820c1db03c839bf97e45a3fab"
uuid = "336ed68f-0bac-5ca0-87d4-7b16caf5d00b"
version = "0.10.14"

[[deps.CodecZlib]]
deps = ["TranscodingStreams", "Zlib_jll"]
git-tree-sha1 = "59939d8a997469ee05c4b4944560a820f9ba0d73"
uuid = "944b1d66-785c-5afd-91f1-9de20f533193"
version = "0.7.4"

[[deps.ColorSchemes]]
deps = ["ColorTypes", "ColorVectorSpace", "Colors", "FixedPointNumbers", "PrecompileTools", "Random"]
git-tree-sha1 = "4b270d6465eb21ae89b732182c20dc165f8bf9f2"
uuid = "35d6a980-a343-548e-a6ea-1d62b119f2f4"
version = "3.25.0"

[[deps.ColorTypes]]
deps = ["FixedPointNumbers", "Random"]
git-tree-sha1 = "b10d0b65641d57b8b4d5e234446582de5047050d"
uuid = "3da002f7-5984-5a60-b8a6-cbb66c0b333f"
version = "0.11.5"

[[deps.ColorVectorSpace]]
deps = ["ColorTypes", "FixedPointNumbers", "LinearAlgebra", "Requires", "Statistics", "TensorCore"]
git-tree-sha1 = "a1f44953f2382ebb937d60dafbe2deea4bd23249"
uuid = "c3611d14-8923-5661-9e6a-0046d554d3a4"
version = "0.10.0"

    [deps.ColorVectorSpace.extensions]
    SpecialFunctionsExt = "SpecialFunctions"

    [deps.ColorVectorSpace.weakdeps]
    SpecialFunctions = "276daf66-3868-5448-9aa4-cd146d93841b"

[[deps.Colors]]
deps = ["ColorTypes", "FixedPointNumbers", "Reexport"]
git-tree-sha1 = "362a287c3aa50601b0bc359053d5c2468f0e7ce0"
uuid = "5ae59095-9a9b-59fe-a467-6f913c188581"
version = "0.12.11"

[[deps.Compat]]
deps = ["TOML", "UUIDs"]
git-tree-sha1 = "b1c55339b7c6c350ee89f2c1604299660525b248"
uuid = "34da2185-b29b-5c13-b0c7-acf172513d20"
version = "4.15.0"
weakdeps = ["Dates", "LinearAlgebra"]

    [deps.Compat.extensions]
    CompatLinearAlgebraExt = "LinearAlgebra"

[[deps.CompilerSupportLibraries_jll]]
deps = ["Artifacts", "Libdl"]
uuid = "e66e0078-7015-5450-92f7-15fbd957f2ae"
version = "1.0.5+1"

[[deps.Crayons]]
git-tree-sha1 = "249fe38abf76d48563e2f4556bebd215aa317e15"
uuid = "a8cc5b0e-0ffa-5ad4-8c14-923d3ee1735f"
version = "4.1.1"

[[deps.DataAPI]]
git-tree-sha1 = "abe83f3a2f1b857aac70ef8b269080af17764bbe"
uuid = "9a962f9c-6df0-11e9-0e5d-c546b8b5ee8a"
version = "1.16.0"

[[deps.DataFrames]]
deps = ["Compat", "DataAPI", "DataStructures", "Future", "InlineStrings", "InvertedIndices", "IteratorInterfaceExtensions", "LinearAlgebra", "Markdown", "Missings", "PooledArrays", "PrecompileTools", "PrettyTables", "Printf", "REPL", "Random", "Reexport", "SentinelArrays", "SortingAlgorithms", "Statistics", "TableTraits", "Tables", "Unicode"]
git-tree-sha1 = "04c738083f29f86e62c8afc341f0967d8717bdb8"
uuid = "a93c6f00-e57d-5684-b7b6-d8193f3e46c0"
version = "1.6.1"

[[deps.DataStructures]]
deps = ["Compat", "InteractiveUtils", "OrderedCollections"]
git-tree-sha1 = "1d0a14036acb104d9e89698bd408f63ab58cdc82"
uuid = "864edb3b-99cc-5e75-8d2d-829cb0a9cfe8"
version = "0.18.20"

[[deps.DataValueInterfaces]]
git-tree-sha1 = "bfc1187b79289637fa0ef6d4436ebdfe6905cbd6"
uuid = "e2d170a0-9d28-54be-80f0-106bbe20a464"
version = "1.0.0"

[[deps.Dates]]
deps = ["Printf"]
uuid = "ade2ca70-3891-5945-98fb-dc099432e06a"

[[deps.DelimitedFiles]]
deps = ["Mmap"]
git-tree-sha1 = "9e2f36d3c96a820c678f2f1f1782582fcf685bae"
uuid = "8bb1440f-4735-579b-a4ab-409b98df4dab"
version = "1.9.1"

[[deps.DocStringExtensions]]
deps = ["LibGit2"]
git-tree-sha1 = "2fb1e02f2b635d0845df5d7c167fec4dd739b00d"
uuid = "ffbed154-4ef7-542d-bbb7-c09d3a79fcae"
version = "0.9.3"

[[deps.Downloads]]
deps = ["ArgTools", "FileWatching", "LibCURL", "NetworkOptions"]
uuid = "f43a241f-c20a-4ad4-852c-f6b1247861c6"
version = "1.6.0"

[[deps.FilePathsBase]]
deps = ["Compat", "Dates", "Mmap", "Printf", "Test", "UUIDs"]
git-tree-sha1 = "9f00e42f8d99fdde64d40c8ea5d14269a2e2c1aa"
uuid = "48062228-2e41-5def-b9a4-89aafe57970f"
version = "0.9.21"

[[deps.FileWatching]]
uuid = "7b1f6079-737a-58dc-b8bc-7a2ca5c1b5ee"

[[deps.FixedPointNumbers]]
deps = ["Statistics"]
git-tree-sha1 = "05882d6995ae5c12bb5f36dd2ed3f61c98cbb172"
uuid = "53c48c17-4a7d-5ca2-90c5-79b7896eea93"
version = "0.8.5"

[[deps.Future]]
deps = ["Random"]
uuid = "9fa8497b-333b-5362-9e8d-4d0656e87820"

[[deps.Hyperscript]]
deps = ["Test"]
git-tree-sha1 = "179267cfa5e712760cd43dcae385d7ea90cc25a4"
uuid = "47d2ed2b-36de-50cf-bf87-49c2cf4b8b91"
version = "0.0.5"

[[deps.HypertextLiteral]]
deps = ["Tricks"]
git-tree-sha1 = "7134810b1afce04bbc1045ca1985fbe81ce17653"
uuid = "ac1192a8-f4b3-4bfe-ba22-af5b92cd3ab2"
version = "0.9.5"

[[deps.IOCapture]]
deps = ["Logging", "Random"]
git-tree-sha1 = "8b72179abc660bfab5e28472e019392b97d0985c"
uuid = "b5f81e59-6552-4d32-b1f0-c071b021bf89"
version = "0.2.4"

[[deps.InlineStrings]]
deps = ["Parsers"]
git-tree-sha1 = "9cc2baf75c6d09f9da536ddf58eb2f29dedaf461"
uuid = "842dd82b-1e85-43dc-bf29-5d0ee9dffc48"
version = "1.4.0"

[[deps.InteractiveUtils]]
deps = ["Markdown"]
uuid = "b77e0a4c-d291-57a0-90e8-8db25a27a240"

[[deps.InvertedIndices]]
git-tree-sha1 = "0dc7b50b8d436461be01300fd8cd45aa0274b038"
uuid = "41ab1584-1d38-5bbf-9106-f11c6c58b48f"
version = "1.3.0"

[[deps.IrrationalConstants]]
git-tree-sha1 = "630b497eafcc20001bba38a4651b327dcfc491d2"
uuid = "92d709cd-6900-40b7-9082-c6be49f344b6"
version = "0.2.2"

[[deps.IteratorInterfaceExtensions]]
git-tree-sha1 = "a3f24677c21f5bbe9d2a714f95dcd58337fb2856"
uuid = "82899510-4779-5014-852e-03e436cf321d"
version = "1.0.0"

[[deps.JLLWrappers]]
deps = ["Artifacts", "Preferences"]
git-tree-sha1 = "7e5d6779a1e09a36db2a7b6cff50942a0a7d0fca"
uuid = "692b3bcd-3c85-4b1f-b108-f13ce0eb3210"
version = "1.5.0"

[[deps.JSON]]
deps = ["Dates", "Mmap", "Parsers", "Unicode"]
git-tree-sha1 = "31e996f0a15c7b280ba9f76636b3ff9e2ae58c9a"
uuid = "682c06a0-de6a-54ab-a142-c8b1cf79cde6"
version = "0.21.4"

[[deps.Kaleido_jll]]
deps = ["Artifacts", "JLLWrappers", "Libdl", "Pkg"]
git-tree-sha1 = "43032da5832754f58d14a91ffbe86d5f176acda9"
uuid = "f7e6163d-2fa5-5f23-b69c-1db539e41963"
version = "0.2.1+0"

[[deps.LaTeXStrings]]
git-tree-sha1 = "50901ebc375ed41dbf8058da26f9de442febbbec"
uuid = "b964fa9f-0449-5b57-a5c2-d3ea65f4040f"
version = "1.3.1"

[[deps.LibCURL]]
deps = ["LibCURL_jll", "MozillaCACerts_jll"]
uuid = "b27032c2-a3e7-50c8-80cd-2d36dbcbfd21"
version = "0.6.4"

[[deps.LibCURL_jll]]
deps = ["Artifacts", "LibSSH2_jll", "Libdl", "MbedTLS_jll", "Zlib_jll", "nghttp2_jll"]
uuid = "deac9b47-8bc7-5906-a0fe-35ac56dc84c0"
version = "8.4.0+0"

[[deps.LibGit2]]
deps = ["Base64", "LibGit2_jll", "NetworkOptions", "Printf", "SHA"]
uuid = "76f85450-5226-5b5a-8eaa-529ad045b433"

[[deps.LibGit2_jll]]
deps = ["Artifacts", "LibSSH2_jll", "Libdl", "MbedTLS_jll"]
uuid = "e37daf67-58a4-590a-8e99-b0245dd2ffc5"
version = "1.6.4+0"

[[deps.LibSSH2_jll]]
deps = ["Artifacts", "Libdl", "MbedTLS_jll"]
uuid = "29816b5a-b9ab-546f-933c-edad1886dfa8"
version = "1.11.0+1"

[[deps.Libdl]]
uuid = "8f399da3-3557-5675-b5ff-fb832c97cbdb"

[[deps.LinearAlgebra]]
deps = ["Libdl", "OpenBLAS_jll", "libblastrampoline_jll"]
uuid = "37e2e46d-f89d-539d-b4ee-838fcccc9c8e"

[[deps.LogExpFunctions]]
deps = ["DocStringExtensions", "IrrationalConstants", "LinearAlgebra"]
git-tree-sha1 = "18144f3e9cbe9b15b070288eef858f71b291ce37"
uuid = "2ab3a3ac-af41-5b50-aa03-7779005ae688"
version = "0.3.27"

    [deps.LogExpFunctions.extensions]
    LogExpFunctionsChainRulesCoreExt = "ChainRulesCore"
    LogExpFunctionsChangesOfVariablesExt = "ChangesOfVariables"
    LogExpFunctionsInverseFunctionsExt = "InverseFunctions"

    [deps.LogExpFunctions.weakdeps]
    ChainRulesCore = "d360d2e6-b24c-11e9-a2a3-2a2ae2dbcce4"
    ChangesOfVariables = "9e997f8a-9a97-42d5-a9f1-ce6bfc15e2c0"
    InverseFunctions = "3587e190-3f89-42d0-90ee-14403ec27112"

[[deps.Logging]]
uuid = "56ddb016-857b-54e1-b83d-db4d58db5568"

[[deps.MIMEs]]
git-tree-sha1 = "65f28ad4b594aebe22157d6fac869786a255b7eb"
uuid = "6c6e2e6c-3030-632d-7369-2d6c69616d65"
version = "0.1.4"

[[deps.Markdown]]
deps = ["Base64"]
uuid = "d6f4376e-aef5-505a-96c1-9c027394607a"

[[deps.MbedTLS_jll]]
deps = ["Artifacts", "Libdl"]
uuid = "c8ffd9c3-330d-5841-b78e-0817d7145fa1"
version = "2.28.2+1"

[[deps.Missings]]
deps = ["DataAPI"]
git-tree-sha1 = "ec4f7fbeab05d7747bdf98eb74d130a2a2ed298d"
uuid = "e1d29d7a-bbdc-5cf2-9ac0-f12de2c33e28"
version = "1.2.0"

[[deps.Mmap]]
uuid = "a63ad114-7e13-5084-954f-fe012c677804"

[[deps.MozillaCACerts_jll]]
uuid = "14a3606d-f60d-562e-9121-12d972cd8159"
version = "2023.1.10"

[[deps.NetworkOptions]]
uuid = "ca575930-c2e3-43a9-ace4-1e988b2c1908"
version = "1.2.0"

[[deps.OpenBLAS_jll]]
deps = ["Artifacts", "CompilerSupportLibraries_jll", "Libdl"]
uuid = "4536629a-c528-5b80-bd46-f80d51c5b363"
version = "0.3.23+2"

[[deps.OrderedCollections]]
git-tree-sha1 = "dfdf5519f235516220579f949664f1bf44e741c5"
uuid = "bac558e1-5e72-5ebc-8fee-abe8a469f55d"
version = "1.6.3"

[[deps.Parameters]]
deps = ["OrderedCollections", "UnPack"]
git-tree-sha1 = "34c0e9ad262e5f7fc75b10a9952ca7692cfc5fbe"
uuid = "d96e819e-fc66-5662-9728-84c9c7592b0a"
version = "0.12.3"

[[deps.Parsers]]
deps = ["Dates", "PrecompileTools", "UUIDs"]
git-tree-sha1 = "8489905bcdbcfac64d1daa51ca07c0d8f0283821"
uuid = "69de0a69-1ddd-5017-9359-2bf0b02dc9f0"
version = "2.8.1"

[[deps.PeriodicalDates]]
deps = ["Dates", "Printf", "RecipesBase"]
git-tree-sha1 = "e616941f8093e50a373e7d51875143213f82eca4"
uuid = "276e7ca9-e0d7-440b-97bc-a6ae82f545b1"
version = "2.0.0"

[[deps.Pkg]]
deps = ["Artifacts", "Dates", "Downloads", "FileWatching", "LibGit2", "Libdl", "Logging", "Markdown", "Printf", "REPL", "Random", "SHA", "Serialization", "TOML", "Tar", "UUIDs", "p7zip_jll"]
uuid = "44cfe95a-1eb2-52ea-b672-e2afdf69b78f"
version = "1.10.0"

[[deps.PlotlyBase]]
deps = ["ColorSchemes", "Dates", "DelimitedFiles", "DocStringExtensions", "JSON", "LaTeXStrings", "Logging", "Parameters", "Pkg", "REPL", "Requires", "Statistics", "UUIDs"]
git-tree-sha1 = "56baf69781fc5e61607c3e46227ab17f7040ffa2"
uuid = "a03496cd-edff-5a9b-9e67-9cda94a718b5"
version = "0.8.19"

[[deps.PlotlyKaleido]]
deps = ["Base64", "JSON", "Kaleido_jll"]
git-tree-sha1 = "2650cd8fb83f73394996d507b3411a7316f6f184"
uuid = "f2990250-8cf9-495f-b13a-cce12b45703c"
version = "2.2.4"

[[deps.PlutoPlotly]]
deps = ["AbstractPlutoDingetjes", "BaseDirs", "Colors", "Dates", "Downloads", "HypertextLiteral", "InteractiveUtils", "LaTeXStrings", "Markdown", "Pkg", "PlotlyBase", "Reexport", "TOML"]
git-tree-sha1 = "1ae939782a5ce9a004484eab5416411c7190d3ce"
uuid = "8e989ff0-3d88-8e9f-f020-2b208a939ff0"
version = "0.4.6"

    [deps.PlutoPlotly.extensions]
    PlotlyKaleidoExt = "PlotlyKaleido"
    UnitfulExt = "Unitful"

    [deps.PlutoPlotly.weakdeps]
    PlotlyKaleido = "f2990250-8cf9-495f-b13a-cce12b45703c"
    Unitful = "1986cc42-f94f-5a68-af5c-568840ba703d"

[[deps.PlutoUI]]
deps = ["AbstractPlutoDingetjes", "Base64", "ColorTypes", "Dates", "FixedPointNumbers", "Hyperscript", "HypertextLiteral", "IOCapture", "InteractiveUtils", "JSON", "Logging", "MIMEs", "Markdown", "Random", "Reexport", "URIs", "UUIDs"]
git-tree-sha1 = "ab55ee1510ad2af0ff674dbcced5e94921f867a9"
uuid = "7f904dfe-b85e-4ff6-b463-dae2292396a8"
version = "0.7.59"

[[deps.PooledArrays]]
deps = ["DataAPI", "Future"]
git-tree-sha1 = "36d8b4b899628fb92c2749eb488d884a926614d3"
uuid = "2dfb63ee-cc39-5dd5-95bd-886bf059d720"
version = "1.4.3"

[[deps.PrecompileTools]]
deps = ["Preferences"]
git-tree-sha1 = "5aa36f7049a63a1528fe8f7c3f2113413ffd4e1f"
uuid = "aea7be01-6a6a-4083-8856-8a6e6704d82a"
version = "1.2.1"

[[deps.Preferences]]
deps = ["TOML"]
git-tree-sha1 = "9306f6085165d270f7e3db02af26a400d580f5c6"
uuid = "21216c6a-2e73-6563-6e65-726566657250"
version = "1.4.3"

[[deps.PrettyTables]]
deps = ["Crayons", "LaTeXStrings", "Markdown", "PrecompileTools", "Printf", "Reexport", "StringManipulation", "Tables"]
git-tree-sha1 = "66b20dd35966a748321d3b2537c4584cf40387c7"
uuid = "08abe8d2-0d0c-5749-adfa-8a2ac140af0d"
version = "2.3.2"

[[deps.Printf]]
deps = ["Unicode"]
uuid = "de0858da-6303-5e67-8744-51eddeeeb8d7"

[[deps.REPL]]
deps = ["InteractiveUtils", "Markdown", "Sockets", "Unicode"]
uuid = "3fa0cd96-eef1-5676-8a61-b3b8758bbffb"

[[deps.Random]]
deps = ["SHA"]
uuid = "9a3f8284-a2c9-5f02-9a11-845980a1fd5c"

[[deps.RecipesBase]]
deps = ["PrecompileTools"]
git-tree-sha1 = "5c3d09cc4f31f5fc6af001c250bf1278733100ff"
uuid = "3cdcf5f2-1ef4-517c-9805-6587b60abb01"
version = "1.3.4"

[[deps.Reexport]]
git-tree-sha1 = "45e428421666073eab6f2da5c9d310d99bb12f9b"
uuid = "189a3867-3050-52da-a836-e630ba90ab69"
version = "1.2.2"

[[deps.Requires]]
deps = ["UUIDs"]
git-tree-sha1 = "838a3a4188e2ded87a4f9f184b4b0d78a1e91cb7"
uuid = "ae029012-a4dd-5104-9daa-d747884805df"
version = "1.3.0"

[[deps.SHA]]
uuid = "ea8e919c-243c-51af-8825-aaa63cd721ce"
version = "0.7.0"

[[deps.SentinelArrays]]
deps = ["Dates", "Random"]
git-tree-sha1 = "90b4f68892337554d31cdcdbe19e48989f26c7e6"
uuid = "91c51154-3ec4-41a3-a24f-3f23e20d615c"
version = "1.4.3"

[[deps.Serialization]]
uuid = "9e88b42a-f829-5b0c-bbe9-9e923198166b"

[[deps.Sockets]]
uuid = "6462fe0b-24de-5631-8697-dd941f90decc"

[[deps.SortingAlgorithms]]
deps = ["DataStructures"]
git-tree-sha1 = "66e0a8e672a0bdfca2c3f5937efb8538b9ddc085"
uuid = "a2af1166-a08f-5f64-846c-94a0d3cef48c"
version = "1.2.1"

[[deps.SparseArrays]]
deps = ["Libdl", "LinearAlgebra", "Random", "Serialization", "SuiteSparse_jll"]
uuid = "2f01184e-e22b-5df5-ae63-d93ebab69eaf"
version = "1.10.0"

[[deps.Statistics]]
deps = ["LinearAlgebra", "SparseArrays"]
uuid = "10745b16-79ce-11e8-11f9-7d13ad32a3b2"
version = "1.10.0"

[[deps.StatsAPI]]
deps = ["LinearAlgebra"]
git-tree-sha1 = "1ff449ad350c9c4cbc756624d6f8a8c3ef56d3ed"
uuid = "82ae8749-77ed-4fe6-ae5f-f523153014b0"
version = "1.7.0"

[[deps.StatsBase]]
deps = ["DataAPI", "DataStructures", "LinearAlgebra", "LogExpFunctions", "Missings", "Printf", "Random", "SortingAlgorithms", "SparseArrays", "Statistics", "StatsAPI"]
git-tree-sha1 = "5cf7606d6cef84b543b483848d4ae08ad9832b21"
uuid = "2913bbd2-ae8a-5f71-8c99-4fb6c76f3a91"
version = "0.34.3"

[[deps.StringManipulation]]
deps = ["PrecompileTools"]
git-tree-sha1 = "a04cabe79c5f01f4d723cc6704070ada0b9d46d5"
uuid = "892a3eda-7b42-436c-8928-eab12a02cf0e"
version = "0.3.4"

[[deps.SuiteSparse_jll]]
deps = ["Artifacts", "Libdl", "libblastrampoline_jll"]
uuid = "bea87d4a-7f5b-5778-9afe-8cc45184846c"
version = "7.2.1+1"

[[deps.TOML]]
deps = ["Dates"]
uuid = "fa267f1f-6049-4f14-aa54-33bafae1ed76"
version = "1.0.3"

[[deps.TableTraits]]
deps = ["IteratorInterfaceExtensions"]
git-tree-sha1 = "c06b2f539df1c6efa794486abfb6ed2022561a39"
uuid = "3783bdb8-4a98-5b6b-af9a-565f29a5fe9c"
version = "1.0.1"

[[deps.Tables]]
deps = ["DataAPI", "DataValueInterfaces", "IteratorInterfaceExtensions", "LinearAlgebra", "OrderedCollections", "TableTraits"]
git-tree-sha1 = "cb76cf677714c095e535e3501ac7954732aeea2d"
uuid = "bd369af6-aec1-5ad0-b16a-f7cc5008161c"
version = "1.11.1"

[[deps.Tar]]
deps = ["ArgTools", "SHA"]
uuid = "a4e569a6-e804-4fa4-b0f3-eef7a1d5b13e"
version = "1.10.0"

[[deps.TensorCore]]
deps = ["LinearAlgebra"]
git-tree-sha1 = "1feb45f88d133a655e001435632f019a9a1bcdb6"
uuid = "62fd8b95-f654-4bbd-a8a5-9c27f68ccd50"
version = "0.1.1"

[[deps.Test]]
deps = ["InteractiveUtils", "Logging", "Random", "Serialization"]
uuid = "8dfed614-e22c-5e08-85e1-65c5234f0b40"

[[deps.TranscodingStreams]]
git-tree-sha1 = "5d54d076465da49d6746c647022f3b3674e64156"
uuid = "3bb67fe8-82b1-5028-8e26-92a6c54297fa"
version = "0.10.8"
weakdeps = ["Random", "Test"]

    [deps.TranscodingStreams.extensions]
    TestExt = ["Test", "Random"]

[[deps.Tricks]]
git-tree-sha1 = "eae1bb484cd63b36999ee58be2de6c178105112f"
uuid = "410a4b4d-49e4-4fbc-ab6d-cb71b17b3775"
version = "0.1.8"

[[deps.URIs]]
git-tree-sha1 = "67db6cc7b3821e19ebe75791a9dd19c9b1188f2b"
uuid = "5c2747f8-b7ea-4ff2-ba2e-563bfd36b1d4"
version = "1.5.1"

[[deps.UUIDs]]
deps = ["Random", "SHA"]
uuid = "cf7118a7-6976-5b1a-9a39-7adc72f591a4"

[[deps.UnPack]]
git-tree-sha1 = "387c1f73762231e86e0c9c5443ce3b4a0a9a0c2b"
uuid = "3a884ed6-31ef-47d7-9d2a-63182c4928ed"
version = "1.0.2"

[[deps.Unicode]]
uuid = "4ec0a83e-493e-50e2-b9ac-8f72acf5a8f5"

[[deps.WeakRefStrings]]
deps = ["DataAPI", "InlineStrings", "Parsers"]
git-tree-sha1 = "b1be2855ed9ed8eac54e5caff2afcdb442d52c23"
uuid = "ea10d353-3f73-51f8-a26c-33c1cb351aa5"
version = "1.4.2"

[[deps.WorkerUtilities]]
git-tree-sha1 = "cd1659ba0d57b71a464a29e64dbc67cfe83d54e7"
uuid = "76eceee3-57b5-4d4a-8e66-0e911cebbf60"
version = "1.6.1"

[[deps.Zlib_jll]]
deps = ["Libdl"]
uuid = "83775a58-1f1d-513f-b197-d71354ab007a"
version = "1.2.13+1"

[[deps.libblastrampoline_jll]]
deps = ["Artifacts", "Libdl"]
uuid = "8e850b90-86db-534c-a0d3-1478176c7d93"
version = "5.8.0+1"

[[deps.nghttp2_jll]]
deps = ["Artifacts", "Libdl"]
uuid = "8e850ede-7688-5339-a07c-302acd2aaf8d"
version = "1.52.0+1"

[[deps.p7zip_jll]]
deps = ["Artifacts", "Libdl"]
uuid = "3f19e933-33d8-53b3-aaab-bd5110c3b7a0"
version = "17.4.0+2"
"""

# ╔═╡ Cell order:
# ╟─0b869e70-3717-11ec-202c-6b94dac7daf3
# ╟─7e9874b4-a6bd-4b2e-b2db-9421b2f85253
# ╠═b5c47c65-951b-496b-9856-7fd151e7a0f1
# ╠═23e904ee-8f26-4e5e-8a82-b83c4b0610b6
# ╟─694d78c7-4762-4d40-8f9a-6c3d16916d4e
# ╟─a2a3fa86-6e22-433e-9185-147e39059dd2
# ╠═b72215bb-8e3a-46e2-8817-271befe1178c
# ╟─8b34e2c6-34ba-48c0-b7ab-96e14a974adc
# ╟─4109af60-6178-4148-8efe-890245077188
# ╟─402b0789-ee0a-46a0-b3b6-e4a207ed0322
# ╠═fdf4f563-0a9b-416f-b61f-21cac421c975
# ╟─12574710-db69-4ae8-9f44-c74b3a4dce7b
# ╠═a98a56b8-660f-48d7-b8be-9738f73356ee
# ╟─c825ebf2-ce43-452e-aa32-91f2bb4d6be4
# ╟─98989982-df79-46cc-837c-aab48d4d5189
# ╟─d29cc7bd-2f31-41ba-9eed-ed142af21de8
# ╠═d33a43d3-542b-49ec-87f5-627b1b1d18f6
# ╟─da39aafe-7826-4044-92fe-689b0c4ba46e
# ╟─3b99ab82-dfbf-4ce9-8b9c-fb6411563ddd
# ╠═0926d86a-cf95-4b1b-ab7f-0533eb51ac70
# ╟─062ed208-1c98-4339-aeca-16b1522bd437
# ╟─52576c2a-6a38-4873-bf5d-9ccfbd457576
# ╟─1ead53b4-3fab-4dc6-938d-38764c5f5714
# ╠═ac7996b1-f68d-4218-b8d3-31af7fe2a7dc
# ╟─976f8f6d-3fe4-4c22-9e5c-b6534fa23096
# ╠═42df1d8d-06cc-4722-a2df-a9e4026f0f02
# ╟─220511d4-55a3-4a4f-8f88-2177cdab3ee2
# ╠═769bdaf5-0880-40cd-90b4-403546870dc4
# ╟─c25949f7-1d43-40d4-a70e-6582220e7937
# ╟─d87eb178-12d2-4201-8aa1-73d1bd730c96
# ╠═1ef0664e-2f1d-4945-9a56-befb916f08ee
# ╟─008dbf4d-d2c6-42c3-8b78-2cdba0f3a3e2
# ╠═135ceb08-8ada-43cd-b8fc-1ab46e65a25c
# ╟─65f3d7a4-7475-4784-8878-07b7cce72d7c
# ╟─f363268e-a9b8-4248-8b99-e6429177b718
# ╟─6ddc8586-f918-4f25-aa3f-1eb798eb0220
# ╟─25a58610-3d1e-4b8d-a26f-71a4fed12f82
# ╠═9d441502-30b8-4669-a5db-7ff9f294fcc9
# ╟─ccc1d5f1-1d59-49ea-a3be-1503e1c5369d
# ╟─85a4e50a-5367-4ca5-b56f-26467f926225
# ╠═67b28656-5b16-46c7-a123-85d049bad845
# ╟─75a7a912-c81c-423e-9d8d-67056ce5e2d2
# ╟─86cd9e00-72a2-46a1-8572-86fad96484b9
# ╟─995cdbb5-54d7-4cff-b4cf-540afcaccc3d
# ╟─8115fbe8-c004-4d2f-a89c-adbb99a337a4
# ╟─dd6264e6-ef0b-4bf2-aa02-0f3d8a1aed3b
# ╟─dc7b0b76-9f15-4e3a-8123-d6b8fcca3c34
# ╟─2ad1f73a-ebd1-40ad-b1db-d48ededc9dd5
# ╟─41137424-e8b4-43c0-b282-7baab6668c66
# ╟─5f164f3c-b18f-44d8-b243-194ccb7c453a
# ╟─74bee8f4-1e6f-4c65-b186-57c1c9c89c6b
# ╠═14b5c3a5-300d-46dd-99e0-20fef8fedb5a
# ╟─dd5d1a4a-60d2-416d-8651-4497ece4889c
# ╟─81c59c4c-2fa3-4a50-aad2-4d56a488afb4
# ╟─f2956bed-9534-4c57-bfaa-fbef3c4af810
# ╟─edbd2b1c-1452-41a6-962c-3434bd420020
# ╟─c7190cc0-08d8-45c8-b5de-e5630e0ff00e
# ╟─d9672a6f-97af-43d1-9a30-50495204fec8
# ╟─73ff8fcc-cfd6-45ba-a741-ecfa65a4cf28
# ╟─00000000-0000-0000-0000-000000000001
# ╟─00000000-0000-0000-0000-000000000002
